/*

 Here you can change the various pin numbers
 and constants, for example I changed the pin
 LED, in order to use it on the pin number 6.

*/

#include <avr/pgmspace.h>
#define NA_CODES

// What pins do what
#define LED 6
#define IRLED 3
#define TRIGGER 1
#define REGIONSWITCH 0

// Set the dalay for flashes
#define DELAY 15000

// Two regions!
#define US 0
#define EU 1

// Lets us calculate the size of the NA/EU databases
#define NUM_ELEM(x) (sizeof (x) / sizeof (*(x)));

// set define to 0 to turn off debug output
#define DEBUG 0
#define DEBUGP(x) if (DEBUG == 1) { x ; }

// Shortcut to insert single, non-optimized-out nop
#define NOP __asm__ __volatile__ ("nop")

// Tweak this if neccessary to change timing
#define DELAY_CNT 25

// Makes the codes more readable. the OCRA is actually
// programmed in terms of 'periods' not 'freqs' - that
// is, the inverse!
#define freq_to_timerval(x) (F_CPU / 8 / x - 1)

// The structure of compressed code entries
struct IrCode {
  uint8_t timer_val;
  uint8_t numpairs;
  uint8_t bitcompression;
  uint16_t const *times;
  uint8_t const*codes;
};
